// priority: 19

global.心之钢配置 = {
    饰品ID: "kubejs:xzg",
    层数增长间隔: 15,
    最少叠加层数: 1,
    最大叠加层数: 5,
    基础生命加成: 10.0,
    每几层加一次生命: 3,
    每次增加多少生命: 2.0,
    治疗加成倍率: 2.0,
    每多少生命值算一次加成: 1, 
    每点生命增加伤害百分比: 0.005, 
    
};
global.心之钢层数NBT = "heart_steel_stacks";
global.心之钢伤害加成值NBT = "heart_steel_damage_bonus_value";
let 心之钢层数增长冷却NBT = "heart_steel_layer_cooldown";
let 心之钢攻击标记NBT = "heart_steel_ready_to_strike";
let 心之钢生命加成UUID = "a7a3c7a7-1c2c-4b3c-9a3e-1b4e0a9b8c7d";
let 心之钢生命加成名称 = "心之钢层数生命加成";
let 心之钢佩戴状态NBT = "heart_steel_is_worn";

let 更新生命值属性 = (p, 总层数, 是否佩戴) => {
    let 属性实例 = p.getAttribute("minecraft:generic.max_health");
    if (!属性实例) { return; }
    属性实例.removeModifier($唯一标识符.fromString(心之钢生命加成UUID));
    
    if (!是否佩戴) { return; }

    let 基础加成 = global.心之钢配置.基础生命加成;
    let 层数加成 = Math.floor(总层数 / global.心之钢配置.每几层加一次生命) * global.心之钢配置.每次增加多少生命;
    let 总加成 = 基础加成 + 层数加成;
    
    if (总加成 > 0) {
        let 修改器UUID = $唯一标识符.fromString(心之钢生命加成UUID);
        let 新修改器 = new $属性修改器(修改器UUID, 心之钢生命加成名称, 总加成, $属性修改器.Operation.ADDITION);
        属性实例.addPermanentModifier(新修改器);
    }
};

PlayerEvents.tick(e => {
    let p = e.player;
    if (!p || !p.server || p.isFake() || p.age % 20 !== 1) { return; }
    if (!(p instanceof $玩家)) { return; }
    
    let pDATA = p.persistentData;
    let 佩戴了心之钢 = false;
    let 心之钢物品实例 = null;

    let 饰品清单选项 = $饰品.getCuriosInventory(p).resolve();
    if (饰品清单选项.isPresent()) {
        let 已装备物品 = 饰品清单选项.get().getEquippedCurios();
        for (let 索引 = 0; 索引 < 已装备物品.getSlots(); 索引++) {
            let 物品堆栈 = 已装备物品.getStackInSlot(索引);
            if (物品堆栈.id === global.心之钢配置.饰品ID) {
                心之钢物品实例 = 物品堆栈;
                佩戴了心之钢 = true;
                break;
            }
        }
    }
    
    let 之前已佩戴 = pDATA.getBoolean(心之钢佩戴状态NBT);

    if (佩戴了心之钢) {
        if (!之前已佩戴) {
            pDATA.putBoolean(心之钢佩戴状态NBT, true);
            let 当前层数 = 心之钢物品实例.getOrCreateTag().getInt(global.心之钢层数NBT) || 0;
            更新生命值属性(p, 当前层数, true);
        }
        
        let 加成计算单位数 = Math.floor(p.health / global.心之钢配置.每多少生命值算一次加成);
        let 伤害加成百分比 = 加成计算单位数 * global.心之钢配置.每点生命增加伤害百分比;
        pDATA.putDouble(global.心之钢伤害加成值NBT, 伤害加成百分比);
        心之钢物品实例.getOrCreateTag().putDouble(global.心之钢伤害加成值NBT, 伤害加成百分比);

        let 当前时间 = p.level.time;
        let 层数增长结束时间 = pDATA.getLong(心之钢层数增长冷却NBT) || 0;
        
        if (当前时间 >= 层数增长结束时间) {
            pDATA.putLong(心之钢层数增长冷却NBT, 当前时间 + global.心之钢配置.层数增长间隔 * 20);
            
            let nbt = 心之钢物品实例.getOrCreateTag();
            let 旧层数 = nbt.getInt(global.心之钢层数NBT) || 0;
            let 本次增加层数 = Math.floor(Math.random() * (global.心之钢配置.最大叠加层数 - global.心之钢配置.最少叠加层数 + 1)) + global.心之钢配置.最少叠加层数;
            let 新层数 = 旧层数 + 本次增加层数;
            nbt.putInt(global.心之钢层数NBT, 新层数);
            更新生命值属性(p, 新层数, true);
            pDATA.putBoolean(心之钢攻击标记NBT, true);
        }

    } else if (之前已佩戴) {
        pDATA.remove(心之钢佩戴状态NBT);
        pDATA.remove(心之钢攻击标记NBT);
        pDATA.remove(global.心之钢伤害加成值NBT);
        更新生命值属性(p, 0, false);
    }
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingHurtEvent"), e => {
    let 伤害源 = e.getSource();
    let 实际攻击者 = 伤害源.getActual();

    if (!(实际攻击者 instanceof $玩家) || 实际攻击者.isFake()) {
        return;
    }

    let 攻击者 = 实际攻击者;
    let 攻击者数据 = 攻击者.persistentData;

    if (攻击者数据.getBoolean(心之钢攻击标记NBT)) {
        let 伤害加成百分比 = 攻击者数据.getDouble(global.心之钢伤害加成值NBT) || 0.0;
        let 原始伤害 = e.getAmount();
        let 额外伤害 = 原始伤害 * 伤害加成百分比;
        let 最终伤害 = 原始伤害 + 额外伤害;

        e.setAmount(最终伤害);
        攻击者.level.playSound(null, 攻击者.x, 攻击者.y, 攻击者.z, "kubejs:xzg", "master", 1.0, 1.0);

        let s = e.getEntity().level.server;
        s.scheduleInTicks(1, () => {
            let p = s.getPlayerList().getPlayer(攻击者.uuid);
            if (p) {
                p.persistentData.remove(心之钢攻击标记NBT);
            }
        });
    }
});

NativeEvents.onEvent(Java.loadClass("net.minecraftforge.event.entity.living.LivingHealEvent"), e => {
    let p = e.getEntity();
    if (!(p instanceof $玩家) || p.isFake()) { return; }

    if (p.persistentData.getBoolean(心之钢佩戴状态NBT)) {
        let 原始治疗量 = e.getAmount();
        let 新治疗量 = 原始治疗量 * global.心之钢配置.治疗加成倍率;
        if (Math.abs(新治疗量 - 原始治疗量) > 0.001) {
            e.setAmount(新治疗量);
        }
    }
});